﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using Excel = Microsoft.Office.Interop.Excel;
using System.Runtime.InteropServices;
using System.Runtime.InteropServices.ComTypes;

namespace AutomatyzacjaExcel
{
    public partial class Form1 : Form
    {
        List<Excel.Application> xlApps
            = new List<Excel.Application>();

        public Form1()
        {
            InitializeComponent();
        }

        private void button1_Click(object sender, EventArgs e)
        {            
            try
            {
                Excel.Application xlApp = (Excel.Application)System.Runtime.InteropServices.
                    Marshal.GetActiveObject("Excel.Application");
                
                Excel.Workbook wb = xlApp.ActiveWorkbook;
                Excel.Worksheet ws = wb.ActiveSheet;

                string informacje =
                    "Nazwa otwartego skoroszytu: " + wb.Name + "\n" +
                    "Nazwa otwartego arkusza: " + ws.Name + "\n" +
                    "Adres aktywnej komórki: " + xlApp.ActiveCell.Address + "\n" +
                    "Wartość aktywnej komórki: " + xlApp.ActiveCell.Value2;

                MessageBox.Show(informacje, Form1.ActiveForm.Name);
            }
            catch
            {
                MessageBox.Show("Aplikacja Excel nie została uruchomiona");
            }
        }

        private void button2_Click(object sender, EventArgs e)
        {
            // Utworzenie nowej instancji aplikacji MS Excel
            Excel.Application xlApp = new Excel.Application();
            
            // Utworzenie pustego skoroszytu
            xlApp.Workbooks.Add();
            
            // Włączenie interfejsu użytkownika serwera automatyzacji MS Excel
            xlApp.Visible = true;

            // Dodanie bieżącej instancji do listy oraz 
            // wyświetlenie nazwy aplikacji i bieżącego skoroszytu
            xlApps.Add(xlApp);
            button3_Click(sender, e);
        }

        private void button3_Click(object sender, EventArgs e)
        {
            listBox1.Items.Clear();           
           
            foreach (Excel.Application xlApp in xlApps)
                listBox1.Items.Add(xlApp.Value.ToString()
                    + " " + xlApp.ActiveWorkbook.Name.ToString());
        }
        
        private void button4_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
            {
                if(xlApps[listBox1.SelectedIndex].ActiveWorkbook != null)
                    xlApps[listBox1.SelectedIndex].ActiveWorkbook.Saved = true;
                xlApps[listBox1.SelectedIndex].Quit();                
                Marshal.FinalReleaseComObject(xlApps[listBox1.SelectedIndex]);                                
                GC.Collect();                
                xlApps.RemoveAt(listBox1.SelectedIndex);
                button3_Click(sender, e);
            }            
            
        }

        private void button5_Click(object sender, EventArgs e)
        {
            treeView1.ResetText();

            if (listBox1.SelectedIndex != -1)
            {
                for (int i = 1; i <= xlApps[listBox1.SelectedIndex].Workbooks.Count; i++)
                {
                    treeView1.Nodes.Add(xlApps[listBox1.SelectedIndex].Workbooks[i].Name);

                    for (int j = 1; j <= xlApps[listBox1.SelectedIndex].Worksheets.Count; j++)
                    {
                        treeView1.Nodes[treeView1.Nodes.Count - 1].Nodes.Add(
                            xlApps[listBox1.SelectedIndex].Workbooks[i].Worksheets[j].Name);
                    }
                }
            }
            else MessageBox.Show("Dokonaj poprawnego wyboru", this.Name);
        }

        private void button6_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
            {
                string nazwaPliku = xlApps[listBox1.SelectedIndex].GetSaveAsFilename(
                    this.Name + ".xlsx", 
                    "Arkusze Excel (*.xlsx), *.xlsx, Wszystkie pliki (*.*), *.*");

                if (nazwaPliku != null)
                {
                    xlApps[listBox1.SelectedIndex].ActiveWorkbook.SaveAs(nazwaPliku);
                    MessageBox.Show("Wybrany skoroszyt zapisano w pliku: "
                        + nazwaPliku, this.Name);
                }
                else MessageBox.Show("Zapis wybranego skoroszytu do pliku:\n"
                    + nazwaPliku + "\nnie powiódł się", this.Name);

            }
            else MessageBox.Show(this.Name, "Dokonaj poprawnego wyboru");
        }

        private void button7_Click(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex != -1)
            {
                if(saveFileDialog1.ShowDialog() == DialogResult.OK)
                {
                    // Wstrzymanie wyświetlania komunikatów aplikacji serwera
                    xlApps[listBox1.SelectedIndex].DisplayAlerts = false;
                    
                    //Zapis skoroszytu do pliku
                    object missing = System.Type.Missing;
                    xlApps[listBox1.SelectedIndex].ActiveWorkbook.SaveAs(
                        saveFileDialog1.FileName, missing, missing, 
                        missing, missing, missing, 
                        Excel.XlSaveAsAccessMode.xlExclusive);
                    MessageBox.Show("Wybrany skoroszyt zapisano w pliku: "
                        + saveFileDialog1.FileName, this.Name);

                    // Wznowienie wyświetlania komunikatów aplikacji serwera
                    xlApps[listBox1.SelectedIndex].DisplayAlerts = true;
                }
                else MessageBox.Show("Zapis wybranego skoroszytu do pliku:\n"
                    + saveFileDialog1.FileName + "\nnie powiódł się", this.Name);

            }
            else MessageBox.Show(this.Name, "Dokonaj poprawnego wyboru");
        }

    }
}
